plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
    id("com.google.gms.google-services")
    kotlin("kapt")
}

android {
    namespace = "com.burhanstore.neonbubblequest"
    compileSdk = 36

    defaultConfig {
        applicationId = "com.burhanstore.neonbubblequest"
        minSdk = 24
        targetSdk = 36
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }

    kotlinOptions {
        jvmTarget = "11"
    }

    buildFeatures {
        viewBinding = true
    }

    configurations.all {
        resolutionStrategy {
            force("org.jetbrains:annotations:23.0.0") // Fix duplicate annotations
        }
    }
}

dependencies {
    // AndroidX Core & UI
    implementation("androidx.core:core-ktx:1.12.0")
    implementation("androidx.appcompat:appcompat:1.7.0")
    implementation("com.google.android.material:material:1.11.0")
    implementation("androidx.constraintlayout:constraintlayout:2.2.0")
    implementation("androidx.recyclerview:recyclerview:1.3.2")
    implementation("androidx.activity:activity-ktx:1.9.0")
    implementation(libs.androidx.activity)

    // Test
    testImplementation("junit:junit:4.13.2")
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")

    // Coroutines
    implementation("org.jetbrains.kotlinx:kotlinx-coroutines-core:1.8.1")
    implementation("org.jetbrains.kotlinx:kotlinx-coroutines-android:1.8.1")

    // Utilities
    implementation("org.apache.commons:commons-text:1.14.0")
    implementation("com.intuit.sdp:sdp-android:1.1.1")
    implementation("com.intuit.ssp:ssp-android:1.1.1")

    // Animations & UI
    implementation("com.airbnb.android:lottie:6.6.7") {
        exclude(group = "com.intellij", module = "annotations")
    }
    implementation("com.facebook.shimmer:shimmer:0.5.0") {
        exclude(group = "com.intellij", module = "annotations")
    }
    implementation("com.makeramen:roundedimageview:2.3.0") {
        exclude(group = "com.intellij", module = "annotations")
    }

    // Retrofit & Gson
    implementation("com.squareup.retrofit2:retrofit:2.11.0") {
        exclude(group = "com.intellij", module = "annotations")
    }
    implementation("com.squareup.retrofit2:converter-gson:2.11.0")
    implementation("com.squareup.okhttp3:logging-interceptor:4.12.0")
    implementation("com.google.code.gson:gson:2.13.2")

    // Bouncy Castle for cryptography
    implementation("org.bouncycastle:bcprov-jdk15on:1.70")

    // Firebase
    implementation(platform("com.google.firebase:firebase-bom:33.16.0"))
    implementation("com.google.firebase:firebase-auth")
    implementation("com.google.firebase:firebase-messaging")
    implementation("com.google.firebase:firebase-analytics")
    implementation("com.google.android.gms:play-services-auth:21.3.0")

    // Glide for image loading
    implementation("com.github.bumptech.glide:glide:4.16.0") {
        exclude(group = "com.intellij", module = "annotations")
    }
    kapt("com.github.bumptech.glide:compiler:4.16.0")


    // Lifecycle
    implementation("androidx.lifecycle:lifecycle-runtime-ktx:2.8.4")

    // Google Ads
    implementation("com.google.android.gms:play-services-ads:24.7.0")

    // Force JetBrains annotations to prevent duplicates
    implementation("org.jetbrains:annotations:23.0.0")
    implementation("com.onesignal:OneSignal:[5.0.0,6.0.0)")


    //monetize sdk
    implementation("com.facebook.android:audience-network-sdk:6.+")
    implementation("com.applovin:applovin-sdk:11.3.2")
    implementation("com.vungle:publisher-sdk-android:6.12.1")
    implementation("com.inmobi.monetization:inmobi-ads-kotlin:10.8.7")


}
